<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

try {
	$Lottery = new \Plugin\Lottery\Lottery();
	
	// LOTTERY
	echo '<div class="lottery-container">';
		echo '<div class="lottery-container-menu">';
			echo '<ul>';
				echo '<li><a href="'.__LOTTERY_HOME__.'">'.lang('lottery_menu_1', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'history/">'.lang('lottery_menu_2', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'stash/">'.lang('lottery_menu_3', true).'</a></li>';
				echo '<li><a href="'.__LOTTERY_HOME__.'results/">'.lang('lottery_menu_4', true).'</a></li>';
				echo '<li><a href="'.config('website_forum_link', true).'" target="_blank">'.lang('lottery_menu_5', true).'</a></li>';
			echo '</ul>';
		echo '</div>';
		echo '<div class="lottery-container-head"></div>';
		echo '<div class="lottery-container-jackpot">';
			echo '<span class="jackpot-title-txt">'.lang('lottery_txt_1', true).'</span><br />';
			echo '<span class="jackpot-txt">' . number_format($Lottery->getJackpot()) . '</span><br />';
			echo '<span class="jackpot-credits-txt">'.lang('lottery_txt_2', true).'</span><br />';
		echo '</div>';
		echo '<div class="lottery-container-numbers">';
			echo '<div class="lottery-container-number">'.$Lottery->showLuckyNumber(1).'</div>';
			echo '<div class="lottery-container-number">'.$Lottery->showLuckyNumber(2).'</div>';
			echo '<div class="lottery-container-number">'.$Lottery->showLuckyNumber(3).'</div>';
			echo '<div class="lottery-container-number">'.$Lottery->showLuckyNumber(4).'</div>';
		echo '</div>';
		echo '<div class="lottery-container-buyticket">';
			echo '<a href="'.__LOTTERY_HOME__.'ticket/" class="btn btn-primary btn-lg">'.lang('lottery_txt_4',true).'</a>';
		echo '</div>';
	echo '</div>';
	
	// INFO
	echo '<table class="myaccount-table">';
		echo '<tr>';
			echo '<td>'.lang('lottery_txt_8',true).'</td>';
			echo '<td>'.$Lottery->getStartDate().'</td>';
		echo '</tr>';
		echo '<tr>';
			echo '<td>'.lang('lottery_txt_9',true).'</td>';
			echo '<td>'.$Lottery->getEndDate().'</td>';
		echo '</tr>';
		echo '<tr>';
			echo '<td>'.lang('lottery_txt_10',true).'</td>';
			echo '<td>'.$Lottery->getTicketCost().' '.lang('lottery_txt_2', true).'</td>';
		echo '</tr>';
		echo '<tr>';
			echo '<td>'.lang('lottery_txt_11',true).'</td>';
			echo '<td>'.$Lottery->getMinNumber().' - '.$Lottery->getMaxNumber().'</td>';
		echo '</tr>';
		echo '<tr>';
			echo '<td>'.lang('lottery_txt_12',true).'</td>';
			echo '<td>'.($Lottery->canBuyTicket() ? '<span class="label label-success">'.lang('lottery_txt_5',true).'</span>' : '<span class="label label-danger">'.lang('lottery_txt_6',true).'</span>').'</td>';
		echo '</tr>';
	echo '</table>';
	
} catch (Exception $ex) {
	message('error', $ex->getMessage());
}